/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWCollectionExtension;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSimpleInstruction;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXPDL_20_parser;
import filenet.vw.base.VWString;
import filenet.vw.base.XMLHelper;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.xml.sax.SAXParseException;

public final class VWWorkflowCollectionDefinition
implements Serializable {
    private static final long serialVersionUID = 722L;
    protected static final String FN_XPDL_200507 = "http://www.filenet.com/ns/fnpe/2005/07/pe/schema/XPDLExtensions";
    protected static final String FN_XPDL_201011 = "http://www.filenet.com/ns/fnpe/2010/11/pe/schema/XPDLExtensions";
    protected static final String FN_XPDL_CURRENT = "http://www.filenet.com/ns/fnpe/2010/11/pe/schema/XPDLExtensions";
    protected static final String XPDL_VERSION = "2.0";
    public static final int WORKFLOW_COLLECTION_SOURCE_NEW = 0;
    public static final int WORKFLOW_COLLECTION_SOURCE_PEP = 1;
    public static final int WORKFLOW_COLLECTION_SOURCE_XPDL = 2;
    public static final String COLLECTION_VALIDATION_KEY = "~CollectionKey";
    public static final int COLLECTION_EXTENSION_SCENARIO_COLLECTION = 0;
    private String description = null;
    private String name = null;
    private String authorTool = null;
    private VWWorkflowDefinition[] workflows = null;
    private VWArrayHandler workflowsHandler = new VWArrayHandler();
    private VWWorkflowDefinition mainWorkflow = null;
    private String applicationSpaceName = "DefaultApplication";
    private Object originalPoolsNode = null;
    private String[] packageAttributes = null;
    private Object scenarioDefinitionsNode = null;
    private transient IVWCollectionExtension scenarioCollectionDefinition = null;
    private int source = 0;
    private String sourceXpdlVersion = "2.0";
    private VWWorkflowDefinition[] externalWorkflows = null;
    private VWArrayHandler externalWorkflowsHandler = new VWArrayHandler();

    public static String _get_FILE_DATE() {
        return "$Date: 2010-07-28 20:25:47 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/10 $";
    }

    public HashMap validate(VWSession theSession, boolean fixupSteps) throws VWException {
        return this.validate(theSession, null, null);
    }

    public HashMap validate(VWSession theSession, VWSystemConfiguration theSystemConfig, String sdfFileContents) throws VWException {
        VWValidationError theError;
        VWString theMessage;
        Vector<VWValidationError> EDefVector = new Vector<VWValidationError>();
        if (this.mainWorkflow == null) {
            theMessage = new VWString("vw.api.VWWorkflowCollectionDefinitionNullMainWorkflow", "The main workflow definition for this collection is null.");
            theError = new VWValidationError(13, 1, null, null, theMessage.toString(), null);
            EDefVector.addElement(theError);
        } else if (!this.isExistingWorkflowName(this.mainWorkflow.getName())) {
            theMessage = new VWString("vw.api.VWWorkflowCollectionDefinitionNoSuchMainWorkflow", "The main workflow definition reference for this collection is invalid.");
            theError = new VWValidationError(13, 1, null, null, theMessage.toString(), null);
            EDefVector.addElement(theError);
        }
        Object[] theCollectionErrors = null;
        if (EDefVector.size() > 0) {
            theCollectionErrors = new VWValidationError[EDefVector.size()];
            EDefVector.copyInto(theCollectionErrors);
        } else {
            theCollectionErrors = new VWValidationError[]{};
        }
        HashMap<String, Object[]> retHashMap = new HashMap<String, Object[]>();
        retHashMap.put(COLLECTION_VALIDATION_KEY, theCollectionErrors);
        VWValidationContext validationContext = new VWValidationContext(theSession, theSystemConfig, sdfFileContents);
        VWWorkflowDefinition[] workflows = this.getWorkflows();
        if (workflows != null) {
            for (int i = 0; i < workflows.length; ++i) {
                if (workflows[i] == null) continue;
                if (workflows[i].getValidateFlag()) {
                    VWValidationError[] theErrors = workflows[i].validate(validationContext);
                    if (theErrors == null) {
                        theErrors = new VWValidationError[]{};
                    }
                    retHashMap.put(workflows[i].getName(), theErrors);
                    continue;
                }
                retHashMap.put(workflows[i].getName(), null);
            }
        }
        return retHashMap;
    }

    public void addWorkflow(VWWorkflowDefinition theWorkflow) throws VWException {
        if (theWorkflow == null) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionNullWorkflowAdd", "Cannot add a null workflow into a collection");
        }
        if (theWorkflow.getName() == null) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionWorkflowAddWithNullName", "Cannot add a workflow that has a null name into a collection");
        }
        if (this.isExistingWorkflowName(theWorkflow.getName())) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionAddWorkflowAlreadyExists", "Cannot add workflow; a workflow named {0} already exists.", theWorkflow.getName());
        }
        theWorkflow.setWorkflowCollection(this);
        this.workflows = (VWWorkflowDefinition[])this.workflowsHandler.addElementToArray(this.workflows, theWorkflow);
        if (this.mainWorkflow == null) {
            this.mainWorkflow = theWorkflow;
        }
    }

    public VWWorkflowDefinition removeWorkflow(String theWorkflowName) throws VWException {
        if (theWorkflowName == null) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionWorkflowDeleteWithNullName", "Cannot delete a workflow from a collection using a null name");
        }
        int index = this.workflowsHandler.getIndexFromStringFieldValue(this.workflows, "name", theWorkflowName);
        if (index == -1) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionWorkflowNotFound", "No workflow found with name equal to \"{0}\" in workflow collection.", theWorkflowName);
        }
        VWWorkflowDefinition wfdef = this.workflows[index];
        wfdef.setWorkflowCollection(null);
        this.workflowsHandler.deleteElementFromArray(this.workflows, index);
        if (this.mainWorkflow == wfdef) {
            this.mainWorkflow = this.workflows[0];
        }
        return wfdef;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theName) throws VWException {
        this.name = theName;
    }

    public String getAuthorTool() {
        return this.authorTool;
    }

    public void setAuthorTool(String theAuthorTool) throws VWException {
        this.authorTool = theAuthorTool;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public VWWorkflowDefinition getWorkflow(String theName) throws VWException {
        return this.getWorkflow(theName, false);
    }

    protected VWWorkflowDefinition getWorkflow(String theName, boolean bIncludeExternal) throws VWException {
        VWWorkflowDefinition wflDef;
        int nIndex = this.workflowsHandler.getIndexFromStringFieldValue(this.workflows, "name", theName);
        if (nIndex != -1) {
            return this.workflows[nIndex];
        }
        if (bIncludeExternal && (wflDef = this.getExternalWorkflow(theName)) != null) {
            return wflDef;
        }
        throw new VWException("vw.api.VWWorkflowCollectionDefinitionWorkflowNotFound", "No workflow found with name equal to \"{0}\" in workflow collection.", theName);
    }

    public VWWorkflowDefinition[] getWorkflows() throws VWException {
        return (VWWorkflowDefinition[])this.workflowsHandler.getElements(this.workflows);
    }

    public int getWorkflowIndex(String theName) throws VWException {
        int index = this.workflowsHandler.getIndexFromStringFieldValue(this.workflows, "name", theName);
        if (index == -1) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionWorkflowNotFound", "No workflow found with name equal to \"{0}\" in workflow collection.", theName);
        }
        return index;
    }

    public static VWWorkflowCollectionDefinition read(InputStream theStream) throws VWException {
        if (theStream == null) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionNullInputStream", "InputStream parameter is null");
        }
        VWWorkflowCollectionDefinition wfc = null;
        try {
            wfc = VWXMLHandler.parseXMLWorkFlowOrXPDL(theStream);
        }
        catch (SAXParseException err) {
            VWString parsingError = new VWString("vw.api.ParsingError", "** Parsing error");
            VWString line = new VWString("vw.api.Line", "line");
            String errString = parsingError + ", " + line + " " + err.getLineNumber() + ", uri " + err.getSystemId() + "\n" + "   " + err.getLocalizedMessage();
            VWException theException = new VWException("vw.api.VWWorkflowCollectionDefinitionXMLReadParse", "XML Parsing error {0}.", errString);
            theException.setCause(err);
            throw theException;
        }
        catch (VWException ex2) {
            throw ex2;
        }
        catch (Exception e2) {
            VWException theException = new VWException("vw.api.VWWorkflowCollectionDefinitionXMLReadError_1", "XML Reading error {0}", e2.getLocalizedMessage());
            theException.setCause(e2);
            throw theException;
        }
        return wfc;
    }

    public static VWWorkflowCollectionDefinition readFromFile(String theFileName) throws VWException {
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(theFileName);
            VWWorkflowCollectionDefinition vWWorkflowCollectionDefinition = VWWorkflowCollectionDefinition.read(istream);
            return vWWorkflowCollectionDefinition;
        }
        catch (VWException ex1) {
            throw ex1;
        }
        catch (Exception e) {
            VWException theException = new VWException("vw.api.VWWorkflowCollectionDefinitionXMLReadFromFileError", " Exception reading XML file: {0}.", e.getLocalizedMessage());
            theException.setCause(e);
            throw theException;
        }
        finally {
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (Exception E) {}
            }
        }
    }

    public void write(OutputStream theStream) throws VWException {
        if (theStream == null) {
            throw new VWException("vw.api.VWWorkFlowDefinitionNullStream", "output stream parameter is null");
        }
        StringBuffer xpdlBuffer = new StringBuffer();
        this.toXPDL(xpdlBuffer);
        try {
            OutputStreamWriter out = new OutputStreamWriter(theStream, "UTF8");
            out.write(xpdlBuffer.toString());
            ((Writer)out).flush();
            this.setSource(2);
        }
        catch (Exception ex) {
            VWException theException = new VWException("vw.api.VWWorkflowCollectionDefinitionXPDLWriteError", " Exception writing XPDL: {0}.", ex.getLocalizedMessage());
            theException.setCause(ex);
            throw theException;
        }
    }

    public void writeToFile(String theFileName) throws VWException {
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(theFileName);
            this.write(ostream);
        }
        catch (VWException ex1) {
            throw ex1;
        }
        catch (Exception ex2) {
            VWException theException = new VWException("vw.api.VWWorkflowCollectionDefinitionXPDLWriteToFileError", " Exception writing XPDL to file: {0}.", ex2.getLocalizedMessage());
            theException.setCause(ex2);
            throw theException;
        }
        finally {
            if (ostream != null) {
                try {
                    ((OutputStream)ostream).close();
                }
                catch (Exception E) {}
            }
        }
    }

    public void export(OutputStream theStream, VWSession session) throws VWException {
        if (theStream == null) {
            throw new VWException("vw.api.VWWorkFlowDefinitionNullStream", "output stream parameter is null");
        }
        VWWorkflowCollectionDefinition flatWFC = new VWWorkflowCollectionDefinition();
        flatWFC.authorTool = this.authorTool;
        flatWFC.description = this.description;
        flatWFC.name = this.name;
        flatWFC.applicationSpaceName = this.applicationSpaceName;
        flatWFC.originalPoolsNode = this.originalPoolsNode;
        flatWFC.packageAttributes = this.packageAttributes;
        flatWFC.scenarioDefinitionsNode = this.scenarioDefinitionsNode;
        flatWFC.scenarioCollectionDefinition = this.scenarioCollectionDefinition;
        VWWorkflowDefinition[] wfdefs = this.getWorkflows();
        if (wfdefs != null) {
            int i;
            int wfCount = wfdefs.length;
            for (i = 0; i < wfCount; ++i) {
                flatWFC.addWorkflow(wfdefs[i].getFlattenedCopy(session));
                flatWFC.workflows[i].name = wfdefs[i].name;
                flatWFC.workflows[i].originalId = wfdefs[i].originalId;
            }
            for (i = 0; i < wfCount; ++i) {
                VWMapDefinition[] maps = flatWFC.workflows[i].getMaps();
                if (maps == null) continue;
                for (int m = 0; m < maps.length; ++m) {
                    VWMapNode[] steps = maps[m].getSteps();
                    if (steps == null) continue;
                    for (int s = 0; s < steps.length; ++s) {
                        VWInstructionDefinition[] instructions;
                        if (!(steps[s] instanceof VWCompoundStepDefinition) || (instructions = ((VWCompoundStepDefinition)steps[s]).getInstructions()) == null) continue;
                        for (int j = 0; j < instructions.length; ++j) {
                            VWWorkflowDefinition referencedWF;
                            VWSimpleInstruction inst;
                            String[] params;
                            if (instructions[j].getAction() != 6 || (params = (inst = (VWSimpleInstruction)instructions[j]).getParams()) == null || params.length <= 0) continue;
                            String wfName = params[0];
                            boolean found = false;
                            VWWorkflowDefinition[] flatWorkflows = flatWFC.getWorkflows();
                            for (int k = 0; k < flatWorkflows.length; ++k) {
                                if (!flatWorkflows[k].name.equals(wfName)) continue;
                                found = true;
                            }
                            if (found || (referencedWF = session.fetchWorkflowDefinition(-1, wfName, true)) == null) continue;
                            flatWFC.addWorkflow(referencedWF);
                            ++wfCount;
                        }
                    }
                }
            }
        }
        StringBuffer xpdlBuffer = new StringBuffer();
        flatWFC.toXPDL(xpdlBuffer);
        try {
            OutputStreamWriter out = new OutputStreamWriter(theStream, "UTF8");
            out.write(xpdlBuffer.toString());
            ((Writer)out).flush();
        }
        catch (Exception ex) {
            VWException theException = new VWException("vw.api.VWWorkflowCollectionDefinitionXPDLExportError", " Exception exporting XPDL: {0}.", ex.getLocalizedMessage());
            theException.setCause(ex);
            throw theException;
        }
    }

    public void exportToFile(String theFileName, VWSession session) throws VWException {
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(theFileName);
            this.export(ostream, session);
        }
        catch (VWException ex1) {
            throw ex1;
        }
        catch (Exception ex2) {
            VWException theException = new VWException("vw.api.VWWorkflowCollectionDefinitionXPDLExportToFileError", " Exception exporting XPDL to file: {0}.", ex2.getLocalizedMessage());
            theException.setCause(ex2);
            throw theException;
        }
        finally {
            if (ostream != null) {
                try {
                    ((OutputStream)ostream).close();
                }
                catch (Exception E) {}
            }
        }
    }

    public String asXPDLString() throws VWException {
        StringBuffer workflowXPDL = new StringBuffer();
        this.toXPDL(workflowXPDL);
        return workflowXPDL.toString();
    }

    public void toXPDL(StringBuffer theBuffer) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        String indent1 = VWXMLHandler.getXMLIndent(1);
        String indent2 = VWXMLHandler.getXMLIndent(2);
        String indent3 = VWXMLHandler.getXMLIndent(3);
        theBuffer.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        theBuffer.append("<Package Id=\"1\"");
        if (this.name != null) {
            theBuffer.append(" Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"");
        }
        theBuffer.append("\n" + indent1 + "xmlns=\"http://www.wfmc.org/2004/XPDL2.0alpha\"\n" + indent1 + "xmlns:deprecated=\"http://www.wfmc.org/2002/XPDL1.0\"\n" + indent1 + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" + indent1 + "xmlns:fn=\"").append("http://www.filenet.com/ns/fnpe/2010/11/pe/schema/XPDLExtensions").append("\"\n");
        if (this.packageAttributes != null) {
            for (int i = 0; i < this.packageAttributes.length; ++i) {
                if (!this.packageAttributes[i].startsWith("xmlns:") || this.packageAttributes[i].startsWith("xmlns:deprecated=") || this.packageAttributes[i].startsWith("xmlns:xsi=") || this.packageAttributes[i].startsWith("xmlns:fn=")) continue;
                theBuffer.append(indent1 + this.packageAttributes[i] + "\n");
            }
        }
        theBuffer.append(indent1 + "xsi:schemaLocation=\"http://www.wfmc.org/2004/XPDL2.0alpha http://www.wfmc.org/standards/docs/TC-1025_bpmnxpdl_24.xsd\">\n");
        theBuffer.append(indent1 + "<PackageHeader");
        if (this.authorTool != null) {
            theBuffer.append(" fn:AuthorTool=\"" + VWXMLHandler.toXMLString(this.authorTool) + "\"");
        }
        if (this.applicationSpaceName != null) {
            theBuffer.append(" fn:ApplicationSpaceName=\"" + VWXMLHandler.toXMLString(this.applicationSpaceName) + "\"");
        }
        theBuffer.append(">\n");
        theBuffer.append(indent2 + "<XPDLVersion>" + XPDL_VERSION + "</XPDLVersion>\n" + indent2 + "<Vendor>FileNet Corporation; Process Engine API; Version " + "4.0" + "</Vendor>\n" + indent2 + "<Created>" + DateFormat.getDateTimeInstance().format(new Date()) + "</Created>\n");
        if (this.description != null) {
            theBuffer.append(indent2 + "<Description>" + VWXMLHandler.toXMLString(this.getDescription()) + "</Description>\n");
        }
        theBuffer.append(indent2 + "<VendorExtensions>\n");
        theBuffer.append(indent3 + "<VendorExtension ToolId=\"FileNetPE\" " + "schemaLocation=\"").append("http://www.filenet.com/ns/fnpe/2010/11/pe/schema/XPDLExtensions").append("\"/>\n");
        theBuffer.append(indent2 + "</VendorExtensions>\n");
        theBuffer.append(indent1 + "</PackageHeader>\n");
        theBuffer.append(indent1 + "<TypeDeclarations>\n");
        String[] fnTypes = new String[]{"attachment", "participant", "xml"};
        for (int i = 0; i < fnTypes.length; ++i) {
            theBuffer.append(indent2 + "<TypeDeclaration Id=\"" + fnTypes[i] + "\" Name=\"" + fnTypes[i] + "\">\n");
            theBuffer.append(indent3 + "<BasicType Type=\"STRING\"/>\n");
            theBuffer.append(indent2 + "</TypeDeclaration>\n");
        }
        theBuffer.append(indent1 + "</TypeDeclarations>\n");
        VWWorkflowDefinition[] wfd = this.getWorkflows();
        if (wfd != null && wfd.length > 0) {
            int i;
            boolean foundPartnerLinkType = false;
            Vector<String> partnerLinkNamesVector = new Vector<String>();
            for (int i2 = 0; i2 < wfd.length; ++i2) {
                VWPartnerLinkDefinition[] partnerLinks = wfd[i2].getPartnerLinks();
                if (partnerLinks == null) continue;
                for (int p = 0; p < partnerLinks.length; ++p) {
                    String[] partnerLinkTypeInfo;
                    if (!foundPartnerLinkType) {
                        theBuffer.append(indent1 + "<PartnerLinkTypes>\n");
                        foundPartnerLinkType = true;
                    }
                    if ((partnerLinkTypeInfo = partnerLinks[p].getPartnerLinkTypeInfo()) == null || partnerLinkNamesVector.indexOf(partnerLinkTypeInfo[0]) >= 0) continue;
                    partnerLinkNamesVector.add(partnerLinkTypeInfo[0]);
                    theBuffer.append(indent2 + "<PartnerLinkType Id=\"" + partnerLinkTypeInfo[0] + "\" name=\"" + partnerLinkTypeInfo[0] + "\">\n");
                    if (partnerLinks[p].getMyPortType() != null || partnerLinks[p].getMyRole() != null) {
                        theBuffer.append(indent3 + "<Role portType=\"");
                        if (partnerLinks[p].getMyPortType() != null) {
                            theBuffer.append(VWXMLHandler.toXMLString(partnerLinks[p].getMyPortType()));
                        }
                        theBuffer.append("\" Name=\"");
                        if (partnerLinks[p].getMyRole() != null) {
                            theBuffer.append(VWXMLHandler.toXMLString(partnerLinks[p].getMyRole()));
                        }
                        theBuffer.append("\"/>\n");
                    }
                    if (partnerLinks[p].getPartnerPortType() != null || partnerLinks[p].getPartnerRole() != null) {
                        theBuffer.append(indent3 + "<Role portType=\"");
                        if (partnerLinks[p].getPartnerPortType() != null) {
                            theBuffer.append(VWXMLHandler.toXMLString(partnerLinks[p].getPartnerPortType()));
                        }
                        theBuffer.append("\" Name=\"");
                        if (partnerLinks[p].getPartnerRole() != null) {
                            theBuffer.append(VWXMLHandler.toXMLString(partnerLinks[p].getPartnerRole()));
                        }
                        theBuffer.append("\"/>\n");
                    }
                    theBuffer.append(indent2 + "</PartnerLinkType>\n");
                }
            }
            if (foundPartnerLinkType) {
                theBuffer.append(indent1 + "</PartnerLinkTypes>\n");
            }
            if (this.originalPoolsNode != null) {
                VWXPDL_20_parser.writeXPDLPools(this, indent1, theBuffer);
            }
            boolean foundArtifact = false;
            boolean foundAssociation = false;
            StringBuffer artifactsBuffer = new StringBuffer();
            for (i = 0; i < wfd.length; ++i) {
                VWMapDefinition[] maps = wfd[i].getMaps();
                if (maps == null) continue;
                for (int m = 0; m < maps.length; ++m) {
                    VWTextAnnotationDefinition[] tads = maps[m].getTextAnnotations();
                    if (tads == null) continue;
                    for (int t = 0; t < tads.length; ++t) {
                        foundArtifact = true;
                        tads[t].toXPDL(indent2, artifactsBuffer);
                        VWAssociationDefinition[] associations = tads[t].getAllAssociations();
                        if (associations == null || associations.length <= 0) continue;
                        if (!foundAssociation) {
                            theBuffer.append(indent1 + "<Associations>\n");
                            foundAssociation = true;
                        }
                        for (int a = 0; a < associations.length; ++a) {
                            associations[a].toXPDL(indent2, theBuffer);
                        }
                    }
                }
            }
            if (foundAssociation) {
                theBuffer.append(indent1 + "</Associations>\n");
            }
            if (foundArtifact) {
                theBuffer.append(indent1 + "<Artifacts>\n");
                theBuffer.append(artifactsBuffer);
                theBuffer.append(indent1 + "</Artifacts>\n");
            }
            theBuffer.append(indent1 + "<WorkflowProcesses>\n");
            for (i = 0; i < wfd.length; ++i) {
                wfd[i].toXPDL(indent2, theBuffer);
            }
            theBuffer.append(indent1 + "</WorkflowProcesses>\n");
            if (this.scenarioCollectionDefinition != null) {
                this.scenarioCollectionDefinition.toXPDL(indent1, theBuffer);
            } else if (this.scenarioDefinitionsNode != null) {
                VWXMLHandler.writeXMLNode(this.scenarioDefinitionsNode, indent1, theBuffer);
            }
        }
        theBuffer.append("</Package>\n");
    }

    public boolean isExistingWorkflowName(String theName) throws VWException {
        return this.isExistingWorkflowName(theName, false);
    }

    protected boolean isExistingWorkflowName(String theName, boolean bIncludeExternal) throws VWException {
        if (theName == null) {
            return false;
        }
        int nIndex = this.workflowsHandler.getIndexFromStringFieldValue(this.workflows, "name", theName);
        if (nIndex != -1) {
            return true;
        }
        if (bIncludeExternal) {
            return this.getExternalWorkflowIndex(theName) != -1;
        }
        return false;
    }

    protected void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t<WorkflowCollection\n");
        if (this.name != null) {
            theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.name) + "\"\n");
        }
        if (this.description != null) {
            theBuffer.append(ATTRIB_INDENT + "Description=\"" + VWXMLHandler.toXMLString(this.description) + "\"\n");
        }
        if (this.authorTool != null) {
            theBuffer.append(ATTRIB_INDENT + "AuthorTool=\"" + VWXMLHandler.toXMLString(this.authorTool) + "\"\n");
        }
        if (this.applicationSpaceName != null) {
            theBuffer.append(ATTRIB_INDENT + "ApplicationSpaceName=\"" + VWXMLHandler.toXMLString(this.applicationSpaceName) + "\"\n");
        }
        theBuffer.append(" >\n");
        VWWorkflowDefinition[] w = this.getWorkflows();
        if (w != null) {
            for (int i = 0; i < w.length; ++i) {
                if (!this.workflows[i].getTransferFlag()) continue;
                w[i].toXML_withNoXMLDeclaration(theBuffer);
            }
        }
        theBuffer.append("\t</WorkflowCollection>\n");
    }

    protected String asXMLString() throws VWException {
        StringBuffer workflowCollXML = new StringBuffer();
        this.toXML(workflowCollXML);
        return workflowCollXML.toString();
    }

    public VWWorkflowDefinition getMainWorkflow() {
        if (this.mainWorkflow == null && this.workflows != null && this.workflows.length > 0) {
            this.mainWorkflow = this.workflows[0];
        }
        return this.mainWorkflow;
    }

    public void setMainWorkflowByName(String theName) throws VWException {
        if (theName == null || !this.isExistingWorkflowName(theName)) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionWorkflowNotFound2", "Cannot set the main workflow to \"{0}\" because there is no workflow with that name in the workflow collection.", theName == null ? "" : theName);
        }
        this.mainWorkflow = this.getWorkflow(theName);
        if (this.mainWorkflow != this.workflows[0]) {
            int index = this.workflowsHandler.getIndexFromStringFieldValue(this.workflows, "name", theName);
            this.workflows[index] = this.workflows[0];
            this.workflows[0] = this.mainWorkflow;
        }
    }

    public String getApplicationSpaceName() {
        return this.applicationSpaceName;
    }

    public void setApplicationSpaceName(String newApplicationSpaceName) {
        this.applicationSpaceName = newApplicationSpaceName;
    }

    protected void setSource(int newSource) throws VWException {
        switch (newSource) {
            case 0: 
            case 1: 
            case 2: {
                this.source = newSource;
                break;
            }
            default: {
                throw new VWException("vw.api.VWWorkflowCollectionDefinitionInvalidSource", "Invalid source.");
            }
        }
    }

    public int getSource() {
        return this.source;
    }

    protected void setOriginalPoolsNode(Object obj) {
        this.originalPoolsNode = obj;
    }

    protected Object getOriginalPoolsNode() {
        return this.originalPoolsNode;
    }

    protected void setPackageAttributes(String[] pa) {
        this.packageAttributes = pa;
    }

    protected void setScenarioDefinitionsNode(Object obj) {
        this.scenarioDefinitionsNode = obj;
    }

    public Object registerCollectionExtension(int nExtensionType, IVWCollectionExtension collectionExtension) {
        switch (nExtensionType) {
            case 0: {
                this.scenarioCollectionDefinition = collectionExtension;
                return this.scenarioDefinitionsNode;
            }
        }
        return null;
    }

    protected static boolean isFNExtension(String namespace) {
        return namespace != null && namespace.indexOf("pe/schema/XPDLExtensions") > 0;
    }

    public String getXpdlSourceVersion() {
        return this.sourceXpdlVersion;
    }

    protected void setXpdlSourceVersion(String xpdlVersion) {
        this.sourceXpdlVersion = xpdlVersion;
    }

    public void registerExternalWorkflowsFromCollection(VWWorkflowCollectionDefinition theWorkflowCollection) throws VWException {
        if (theWorkflowCollection == null) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionNullRegisterExternal", "The workflow collection can not be null.");
        }
        VWWorkflowDefinition[] newExternalWorkflows = theWorkflowCollection.getWorkflows();
        if (newExternalWorkflows != null) {
            for (int i = 0; i < newExternalWorkflows.length; ++i) {
                String wflName;
                VWWorkflowDefinition theWorkflow = newExternalWorkflows[i];
                if (theWorkflow == null || (wflName = theWorkflow.getName()) == null || this.isExistingWorkflowName(wflName, true)) continue;
                String baseWorkClassName = theWorkflow.getBaseWorkClassName();
                VWWorkflowDefinition wflDefCopy = (VWWorkflowDefinition)theWorkflow.clone();
                if (wflDefCopy == null) continue;
                wflDefCopy.setWorkflowCollection(this);
                wflDefCopy.setName(wflName);
                if (baseWorkClassName != null) {
                    wflDefCopy.setBaseWorkClassName(baseWorkClassName);
                }
                this.externalWorkflows = (VWWorkflowDefinition[])this.externalWorkflowsHandler.addElementToArray(this.externalWorkflows, wflDefCopy);
            }
        }
    }

    public void clearExternalWorkflows() {
        this.externalWorkflowsHandler = new VWArrayHandler();
        this.externalWorkflows = null;
    }

    protected VWWorkflowDefinition removeExternalWorkflow(String theWorkflowName) throws VWException {
        int nIndex = this.getExternalWorkflowIndex(theWorkflowName);
        if (nIndex == -1) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionWorkflowNotFound", "No external workflow found with name equal to \"{0}\".", theWorkflowName);
        }
        VWWorkflowDefinition wfdef = this.externalWorkflows[nIndex];
        this.externalWorkflowsHandler.deleteElementFromArray(this.externalWorkflows, nIndex);
        return wfdef;
    }

    protected VWWorkflowDefinition getExternalWorkflow(String theName) throws VWException {
        int nIndex = this.getExternalWorkflowIndex(theName);
        if (nIndex != -1) {
            return this.externalWorkflows[nIndex];
        }
        return null;
    }

    protected VWWorkflowDefinition[] getExternalWorkflows() throws VWException {
        return (VWWorkflowDefinition[])this.externalWorkflowsHandler.getElements(this.externalWorkflows);
    }

    protected int getExternalWorkflowIndex(String theWorkflowName) throws VWException {
        if (theWorkflowName == null) {
            throw new VWException("vw.api.VWWorkflowCollectionDefinitionExternalWorkflowDeleteWithNullName", "The external workflow name is null!");
        }
        return this.externalWorkflowsHandler.getIndexFromStringFieldValue(this.externalWorkflows, "name", theWorkflowName);
    }

    static {
        try {
            XMLHelper.parseDocumentViaDOM(null, null, null, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

